<?php
require '../includes/db.php';
$data = json_decode(file_get_contents('php://input'), true);
$template = 'bill_of_lading';
$client = trim($data['client'] ?? '');
$preset = trim($data['preset'] ?? '');
$values = $data['values'] ?? [];
if (!$client || !$preset) { http_response_code(400); exit; }
$stmt = $pdo->prepare("
INSERT INTO bol_client_preset_values
(template, client_name, preset_name, field_key, value)
VALUES (?, ?, ?, ?, ?)
");
foreach ($values as $field=>$value) {
    if ($value === '') continue;
    $stmt->execute([$template,$client,$preset,$field,$value]);
}
echo json_encode(['status'=>'ok']);
