<?php
session_start();
require_once __DIR__ . '/../config/db_remote.php';

$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if ($username !== '' && $password !== '') {
        $stmt = $mysqli->prepare("
            SELECT id, username, password_hash, full_name, avatar_url, role
            FROM users
            WHERE username = ? AND is_active = 1
            LIMIT 1
        ");
        if ($stmt) {
            $stmt->bind_param("s", $username);
            $stmt->execute();
            $result = $stmt->get_result();
            $user = $result->fetch_assoc();
            $stmt->close();

            if ($user && password_verify($password, $user['password_hash'])) {
                $_SESSION['user'] = [
                    'id'        => $user['id'],
                    'username'  => $user['username'],
                    'full_name' => $user['full_name'],
                    'avatar'    => $user['avatar_url'],
                    'role'      => $user['role'],
                ];
                header('Location: ../pages/dashboard.php');
                exit;
            } else {
                $error = 'Invalid username or password.';
            }
        } else {
            $error = 'Database error.';
        }
    } else {
        $error = 'Please enter username and password.';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Login - SM Produce LTD</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- Bootstrap -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
body {
    margin: 0;
    font-family: 'Inter', sans-serif;
    background: radial-gradient(circle at top left, #e0f2fe, #f9fafb);
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
}

.login-card {
    width: 100%;
    max-width: 420px;
    background: #ffffff;
    border-radius: 16px;
    box-shadow: 0 18px 45px rgba(15, 23, 42, 0.12);
    padding: 28px 30px 26px;
}

.login-logo {
    text-align: center;
    margin-bottom: 16px;
}

.login-logo img {
    height: 64px;
    width: auto;
    margin-bottom: 6px;
}

.login-title {
    font-size: 20px;
    font-weight: 700;
    text-align: center;
    margin-bottom: 4px;
}

.login-subtitle {
    font-size: 13px;
    color: #6b7280;
    text-align: center;
    margin-bottom: 18px;
}

.form-label {
    font-size: 13px;
    font-weight: 600;
    color: #374151;
}

.btn-login {
    width: 100%;
    height: 46px;
    background: #0d6efd;
    border: none;
    border-radius: 999px;
    font-size: 15px;
    color: #ffffff;
    font-weight: 600;
    transition: background .18s ease, transform .1s ease;
}

.btn-login:hover {
    background: #0b5ed7;
    transform: translateY(-1px);
}

.error-box {
    font-size: 13px;
}
</style>
</head>
<body>

<div class="login-card">
    <div class="login-logo">
        <img src="/smproduce/logo/logo.png" alt="SM Produce LTD">
        <div class="login-title">SM Produce LTD</div>
        <div class="login-subtitle">Sign in to access the production dashboard</div>
    </div>

    <?php if ($error): ?>
        <div class="alert alert-danger py-2 px-3 mb-3 error-box">
            <?php echo htmlspecialchars($error); ?>
        </div>
    <?php endif; ?>

    <form method="post" class="text-start">
        <div class="mb-3">
            <label class="form-label">Username</label>
            <input type="text" name="username" class="form-control" required autofocus>
        </div>

        <div class="mb-4">
            <label class="form-label">Password</label>
            <input type="password" name="password" class="form-control" required>
        </div>

        <button class="btn-login">Login</button>
    </form>
</div>

</body>
</html>
