<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
$current = basename($_SERVER['PHP_SELF']);
?>

<style>
#sidebarMenu {
    width: 260px;
    background: #ffffff;
    height: 100vh;
    border-right: 1px solid #e2e2e2;
    position: fixed;
    left: 0;
    top: 0;
    padding-top: 16px;
    z-index: 1000;
}

.sidebar-logo {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 0 18px 16px 18px;
    border-bottom: 1px solid #f0f0f0;
    margin-bottom: 8px;
}

.sidebar-logo img {
    height: 40px;
    width: auto;
}

.sidebar-logo span {
    font-weight: 700;
    font-size: 17px;
}

.sidebar-section-title {
    font-size: 12px;
    text-transform: uppercase;
    letter-spacing: .04em;
    color: #9ca3af;
    padding: 8px 18px 4px;
}

.sidebar-item {
    display: flex;
    align-items: center;
    padding: 9px 18px;
    text-decoration: none;
    color: #374151;
    font-size: 14px;
    gap: 10px;
    transition: background .15s ease, color .15s ease;
}

.sidebar-item:hover {
    background: #f3f4f6;
    color: #111827;
}

.sidebar-item.active {
    background: #e5f0ff;
    color: #1d4ed8;
    font-weight: 600;
}

.sidebar-item.sub {
    padding-left: 42px;
    font-size: 13.5px;
}

.sidebar-icon {
    width: 22px;
    text-align: center;
}
</style>

<nav id="sidebarMenu">

    <!-- LOGO -->
    <div class="sidebar-logo">
        <img src="/smproduce/logo/logo.png" alt="SM Produce LTD">
        <span>SM Produce LTD</span>
    </div>

    <!-- MAIN -->
    <div class="sidebar-section-title">Main</div>
    <a href="/smproduce/pages/dashboard.php"
       class="sidebar-item <?= ($current === 'dashboard.php') ? 'active' : ''; ?>">
        <span class="sidebar-icon">📊</span>
        <span>Dashboard</span>
    </a>

    <!-- BINS -->
    <div class="sidebar-section-title">Bins</div>
    <a href="/smproduce/pages/bins_ingresso.php"
       class="sidebar-item <?= ($current === 'bins_ingresso.php') ? 'active' : ''; ?>">
        <span class="sidebar-icon">📥</span>
        <span>Full Bins Inventory</span>
    </a>

    <a href="/smproduce/pages/empty_bin_receiving.php"
       class="sidebar-item <?= ($current === 'empty_bin_receiving.php') ? 'active' : ''; ?>">
        <span class="sidebar-icon">📦</span>
        <span>Empty Bins</span>
    </a>

    <a href="/smproduce/pages/dumping_bins.php"
       class="sidebar-item <?= ($current === 'dumping_bins.php') ? 'active' : ''; ?>">
        <span class="sidebar-icon">🗑</span>
        <span>Dumping Bins</span>
    </a>

    <!-- PRODUCTION -->
    <div class="sidebar-section-title">Production</div>
    <a href="/smproduce/pages/production_summary.php"
       class="sidebar-item <?= ($current === 'production_summary.php') ? 'active' : ''; ?>">
        <span class="sidebar-icon">🏭</span>
        <span>Production Summary</span>
    </a>

    <!-- LOGISTICS -->
    <div class="sidebar-section-title">Logistics</div>

    <!-- BILL OF LADING ROOT -->
    <a href="/smproduce/pages/bill_of_lading.php"
       class="sidebar-item <?= ($current === 'bill_of_lading.php') ? 'active' : ''; ?>">
        <span class="sidebar-icon">📄</span>
        <span>Bill of Lading</span>
    </a>

    <!-- BOL SUB MENU -->
    <a href="/smproduce/pages/bill_of_lading.php"
       class="sidebar-item sub <?= ($current === 'bill_of_lading.php') ? 'active' : ''; ?>">
        <span class="sidebar-icon">📑</span>
        <span>Documents</span>
    </a>

    <a href="/smproduce/pages/bol_template_editor.php"
       class="sidebar-item sub <?= ($current === 'bol_template_editor.php') ? 'active' : ''; ?>">
        <span class="sidebar-icon">🎨</span>
        <span>Template Editor</span>
    </a>

    <a href="/smproduce/pages/bol_presets.php"
       class="sidebar-item sub <?= ($current === 'bol_presets.php') ? 'active' : ''; ?>">
        <span class="sidebar-icon">🧩</span>
        <span>Presets</span>
    </a>

    <!-- IBC -->
    <div class="sidebar-section-title">IBC</div>
    <a href="/smproduce/pages/ibc_manager.php"
       class="sidebar-item <?= ($current === 'ibc_manager.php') ? 'active' : ''; ?>">
        <span class="sidebar-icon">🧴</span>
        <span>IBC Manager</span>
    </a>

    <!-- ORDERS -->
    <div class="sidebar-section-title">Orders</div>
    <a href="/smproduce/pages/orders.php"
       class="sidebar-item <?= ($current === 'orders.php') ? 'active' : ''; ?>">
        <span class="sidebar-icon">🧾</span>
        <span>Orders</span>
    </a>

    <!-- USERS -->
    <div class="sidebar-section-title">Users</div>
    <a href="/smproduce/pages/users.php"
       class="sidebar-item <?= ($current === 'users.php') ? 'active' : ''; ?>">
        <span class="sidebar-icon">👤</span>
        <span>Users</span>
    </a>

    <!-- SETTINGS -->
    <div class="sidebar-section-title">Settings</div>
    <a href="/smproduce/pages/settings.php"
       class="sidebar-item <?= ($current === 'settings.php') ? 'active' : ''; ?>">
        <span class="sidebar-icon">⚙️</span>
        <span>General Settings</span>
    </a>

    <!-- LOGOUT -->
    <div class="mt-4 px-3">
        <a href="/smproduce/auth/logout.php" class="sidebar-item text-danger">
            <span class="sidebar-icon">🔒</span>
            <span>Logout</span>
        </a>
    </div>

</nav>
