const net = require('net');
const fs = require('fs');
const path = require('path');

const cfgPath = path.join(__dirname, '..', 'config', 'keyence.json');
const cfg = JSON.parse(fs.readFileSync(cfgPath, 'utf8'));

if (!cfg.enabled) {
  console.log('Keyence integration disabled.');
  process.exit(0);
}

const client = new net.Socket();

console.log(`Connecting to Keyence ${cfg.ip}:${cfg.port}`);

client.connect(cfg.port, cfg.ip, () => {
  console.log('Connected to Keyence.');
});

client.on('data', data => {
  const code = data.toString().trim();
  if (code) {
    console.log('BARCODE RECEIVED:', code);
  }
});

client.on('error', err => {
  console.error('TCP ERROR:', err.message);
});
