# Migrazione a Laravel (guida ad alto livello)

Questa app oggi è organizzata come:

- PHP procedurale con pagine in `pages/`
- Config in `config/`
- Include condivisi in `includes/`
- Servizio Node in `keyence_service/`

## Obiettivi Laravel

- Controllers per le funzioni oggi in `pages/*.php` (es. `DashboardController`)
- Models per le tabelle `bins_ingresso`, `bins_produzione`, `boxes_produced`, ecc.
- Routes API per servire JSON alle dashboard (PHP/Next.js)

## Esempio di route Laravel

```php
// routes/web.php
Route::get('/dashboard', [DashboardController::class, 'index']);

// routes/api.php
Route::middleware('auth:sanctum')->get('/dashboard/stats', [DashboardController::class, 'stats']);
```

## Esempio di Controller

```php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function stats()
    {
        $fullBins = DB::table('bins_ingresso')->sum('quantity');
        $dumped   = DB::table('bins_produzione')->sum('quantity');
        $remaining = max(0, $fullBins - $dumped);

        return response()->json([
            'full_bins_total'   => $fullBins,
            'dumped_bins_total' => $dumped,
            'remaining_bins'    => $remaining,
            // TODO: aggiungere query per grafici orari come nella logica attuale di pages/dashboard.php
        ]);
    }
}
```

## Strategia suggerita

1. Creare un nuovo progetto Laravel separato.
2. Copiare la logica SQL da `pages/dashboard.php` dentro a un `DashboardService` o `DashboardController`.
3. Portare gradualmente altre pagine (es. gestione utenti, log, report) a controllers e Blade templates.
4. Tenere compatibile l'API con `api/dashboard_stats.php` per poter riutilizzare il frontend Next.js senza modifiche.
