<?php
require_once __DIR__ . '/db.php';
function userHasPermission($userId, $permissionCode) {
  global $pdo;
  $stmt = $pdo->prepare("
    SELECT 1 FROM user_permissions up
    JOIN permissions p ON p.id = up.permission_id
    WHERE up.user_id = ? AND p.code = ?
    LIMIT 1
  ");
  $stmt->execute([$userId, $permissionCode]);
  if ($stmt->fetch()) return true;

  $stmt = $pdo->prepare("
    SELECT 1 FROM role_permissions rp
    JOIN permissions p ON p.id = rp.permission_id
    JOIN users u ON u.role_id = rp.role_id
    WHERE u.id = ? AND p.code = ?
    LIMIT 1
  ");
  $stmt->execute([$userId, $permissionCode]);
  return (bool)$stmt->fetch();
}
?>