<?php
require_once __DIR__ . '/../config/user_functions.php';
session_start();

if (!isset($_SESSION['user'])) { header('Location: /smproduce/auth/login.php'); exit; }
$role = $_SESSION['user']['role'] ?? 'viewer';
if (!in_array($role, ['admin','warehouse'])) { die('Forbidden'); }

require_once __DIR__ . '/../config/db_remote.php';

$group_id = intval($_GET['group_id'] ?? 0);
if ($group_id <= 0) die("Invalid group");

// get group info
$group = $mysqli->query("
    SELECT grower, variety, lot, date, COUNT(*) AS qty
    FROM bins_ingresso 
    WHERE group_id=$group_id 
")->fetch_assoc();

if (!$group) die("Group not found");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $grower  = $mysqli->real_escape_string($_POST['grower']);
    $variety = $mysqli->real_escape_string($_POST['variety']);
    $date    = $mysqli->real_escape_string($_POST['date']);
    $lot     = $mysqli->real_escape_string($_POST['lot']);

    // update all bins in this group
    $mysqli->query("
        UPDATE bins_ingresso
        SET grower='$grower', variety='$variety', date='$date', lot='$lot'
        WHERE group_id=$group_id
    ");

    header("Location: bins_ingresso.php?msg=Group+Updated");
    exit;
}

// lists
$growers   = $mysqli->query("SELECT name FROM growers_list ORDER BY name ASC")->fetch_all(MYSQLI_ASSOC);
$varieties = $mysqli->query("SELECT name FROM varieties_list ORDER BY name ASC")->fetch_all(MYSQLI_ASSOC);

include('../includes/header.php');
include('../includes/sidebar.php');
?>

<h3 class="mb-3">Edit Group <?= $group_id ?></h3>

<div class="card">
<div class="card-body">

<form method="post" class="row g-3">

    <div class="col-md-3">
        <label class="form-label fw-semibold">Grower</label>
        <select name="grower" class="form-select" required>
            <?php foreach ($growers as $g): ?>
                <option <?= ($group['grower']==$g['name']?'selected':'') ?>>
                    <?= htmlspecialchars($g['name']) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>

    <div class="col-md-3">
        <label class="form-label fw-semibold">Variety</label>
        <select name="variety" class="form-select" required>
            <?php foreach ($varieties as $v): ?>
                <option <?= ($group['variety']==$v['name']?'selected':'') ?>>
                    <?= htmlspecialchars($v['name']) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>

    <div class="col-md-2">
        <label class="form-label">Date</label>
        <input type="date" name="date" class="form-control" 
               value="<?= htmlspecialchars($group['date']) ?>" required>
    </div>

    <div class="col-md-2">
        <label class="form-label">Lot</label>
        <input type="text" name="lot" class="form-control"
               value="<?= htmlspecialchars($group['lot']) ?>">
    </div>

    <div class="col-md-2">
        <label class="form-label">Quantity</label>
        <input type="text" class="form-control" 
               value="<?= $group['qty'] ?>" readonly>
    </div>

    <div class="col-md-12 mt-3">
        <button class="btn btn-success">Save</button>
        <a href="bins_ingresso.php" class="btn btn-secondary">Cancel</a>
    </div>

</form>

</div>
</div>

<?php include('../includes/footer.php'); ?>
