<?php
require_once __DIR__ . '/db.php';

$data = json_decode(file_get_contents('php://input'), true);

$valuesJson = json_encode($data['values'] ?? [], JSON_UNESCAPED_UNICODE);

if (!empty($data['id'])) {

  $stmt = $pdo->prepare("
    UPDATE bol_value_presets
    SET name = ?, description = ?, values_json = ?
    WHERE id = ?
  ");
  $stmt->execute([
    $data['name'],
    $data['description'],
    $valuesJson,
    $data['id']
  ]);

} else {

  $stmt = $pdo->prepare("
    INSERT INTO bol_value_presets (name, description, values_json)
    VALUES (?, ?, ?)
  ");
  $stmt->execute([
    $data['name'],
    $data['description'],
    $valuesJson
  ]);
}
