<?php
// bol_print.php (stampa -> PDF)
$g = $_GET;
$items = [];
if (!empty($g['items'])) {
  $json = json_decode(utf8_decode(urldecode($g['items'])), true);
  // fallback: base64
  $decoded = json_decode(base64_decode($g['items']), true);
  $items = is_array($decoded) ? $decoded : [];
}
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Bill of Lading - Print</title>
<style>
@media print { .no-print { display:none; } }
body { font-family: Arial, sans-serif; margin:0; padding:18px; }
.header { display:flex; justify-content:space-between; align-items:flex-end; border-bottom:1px solid #ddd; padding-bottom:10px; margin-bottom:12px; }
h1 { font-size:18px; margin:0; }
.small { font-size:12px; color:#555; }
.block { border:1px solid #ddd; padding:10px; border-radius:8px; margin-bottom:10px; }
.row { display:flex; gap:10px; }
.col { flex:1; }
label { font-size:11px; color:#444; font-weight:700; display:block; margin-bottom:4px; }
.value { font-size:13px; border:1px solid #eee; padding:8px; border-radius:6px; min-height:16px; }
table { width:100%; border-collapse:collapse; }
th, td { border:1px solid #ddd; padding:8px; font-size:12px; }
th { background:#f6f6f6; text-align:left; }
.sig img { max-width:320px; border:1px solid #eee; padding:6px; border-radius:8px; background:#fff; }
</style>
</head>
<body>

<div class="header">
  <div>
    <h1>SM Produce LTD - Bill of Lading</h1>
    <div class="small">Export (Print to PDF)</div>
  </div>
  <div class="no-print">
    <button onclick="window.print()">Print / Save as PDF</button>
  </div>
</div>

<div class="block">
  <div class="row">
    <div class="col"><label>Date</label><div class="value"><?= htmlspecialchars($g['date'] ?? '') ?></div></div>
    <div class="col"><label>REF #</label><div class="value"><?= htmlspecialchars($g['ref'] ?? '') ?></div></div>
    <div class="col"><label>CUST PO</label><div class="value"><?= htmlspecialchars($g['cust_po'] ?? '') ?></div></div>
  </div>
</div>

<div class="block">
  <div class="row">
    <div class="col"><label>Pick Up</label><div class="value"><?= htmlspecialchars($g['pickup'] ?? '') ?></div></div>
    <div class="col"><label>Dest City</label><div class="value"><?= htmlspecialchars($g['dest_city'] ?? '') ?></div></div>
  </div>
  <div class="row" style="margin-top:10px">
    <div class="col"><label>AWB</label><div class="value"><?= htmlspecialchars($g['awb'] ?? '') ?></div></div>
    <div class="col"><label>Consignee</label><div class="value"><?= htmlspecialchars($g['consignee'] ?? '') ?></div></div>
  </div>
</div>

<div class="block">
  <label>Products</label>
  <table>
    <thead><tr><th>CTNS</th><th>PLTS</th><th>Description</th><th>Pack</th><th>Weight</th></tr></thead>
    <tbody>
      <?php foreach ($items as $it): ?>
      <tr>
        <td><?= htmlspecialchars($it['ctns'] ?? '') ?></td>
        <td><?= htmlspecialchars($it['plts'] ?? '') ?></td>
        <td><?= htmlspecialchars($it['description'] ?? '') ?></td>
        <td><?= htmlspecialchars($it['pack'] ?? '') ?></td>
        <td><?= htmlspecialchars($it['weight'] ?? '') ?></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<div class="block">
  <label>Notes</label>
  <div class="value"><?= nl2br(htmlspecialchars($g['notes'] ?? '')) ?></div>
</div>

<div class="block sig">
  <label>Signature</label>
  <?php if (!empty($g['sig'])): ?>
    <img src="<?= htmlspecialchars($g['sig']) ?>" alt="Signature">
  <?php else: ?>
    <div class="small">No signature</div>
  <?php endif; ?>
</div>

</body>
</html>
