<?php
require_once __DIR__ . '/../config/user_functions.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once __DIR__ . '/../config/users_local.php';
if (!isset($_SESSION['user']) || !user_has_permission('dashboard_kpi')) {
    echo "<h3 class='m-4 text-danger'>Access denied</h3>";
    exit;
}

require_once __DIR__ . '/../config/db_remote.php';

function kpi_total_int($sql) {
    global $mysqli;
    $res = $mysqli->query($sql);
    if ($res && $row = $res->fetch_assoc()) {
        return (int)$row['total'];
    }
    return 0;
}

function kpi_total_float($sql) {
    global $mysqli;
    $res = $mysqli->query($sql);
    if ($res && $row = $res->fetch_assoc()) {
        return (float)$row['total'];
    }
    return 0.0;
}

// FULL BINS KPIs
$full_available = kpi_total_int("
    SELECT COALESCE(SUM(quantity),0) AS total
    FROM bins_ingresso
    WHERE status = 'AVAILABLE'
");

$full_in_production = kpi_total_int("
    SELECT COALESCE(SUM(quantity),0) AS total
    FROM bins_ingresso
    WHERE status = 'IN_PRODUCTION'
");

$full_used = kpi_total_int("
    SELECT COALESCE(SUM(quantity),0) AS total
    FROM bins_ingresso
    WHERE status = 'USED'
");

$full_scrap = kpi_total_int("
    SELECT COALESCE(SUM(quantity),0) AS total
    FROM bins_ingresso
    WHERE status = 'SCRAP'
");

// DUMPED BINS KPIs (riuso logica di dashboard)
$dumped_today = kpi_total_int("
    SELECT COALESCE(SUM(quantity),0) AS total
    FROM bins_ingresso
    WHERE status='DUMPED'
      AND DATE(updated_at)=CURDATE()
");

$dumped_week = kpi_total_int("
    SELECT COALESCE(SUM(quantity),0) AS total
    FROM bins_ingresso
    WHERE status='DUMPED'
      AND YEARWEEK(updated_at,1)=YEARWEEK(CURDATE(),1)
");

$dumped_month = kpi_total_int("
    SELECT COALESCE(SUM(quantity),0) AS total
    FROM bins_ingresso
    WHERE status='DUMPED'
      AND YEAR(updated_at)=YEAR(CURDATE())
      AND MONTH(updated_at)=MONTH(CURDATE())
");

$dumped_total = kpi_total_int("
    SELECT COALESCE(SUM(quantity),0) AS total
    FROM bins_ingresso
    WHERE status='DUMPED'
");

// BOXES PRODUCED KPIs
$boxes_today = kpi_total_int("
    SELECT COALESCE(SUM(boxes_produced),0) AS total
    FROM activity_log
    WHERE DATE(timestamp)=CURDATE()
");

$boxes_week = kpi_total_int("
    SELECT COALESCE(SUM(boxes_produced),0) AS total
    FROM activity_log
    WHERE YEARWEEK(timestamp,1)=YEARWEEK(CURDATE(),1)
");

$boxes_month = kpi_total_int("
    SELECT COALESCE(SUM(boxes_produced),0) AS total
    FROM activity_log
    WHERE YEAR(timestamp)=YEAR(CURDATE())
      AND MONTH(timestamp)=MONTH(CURDATE())
");

$boxes_total = kpi_total_int("
    SELECT COALESCE(SUM(boxes_produced),0) AS total
    FROM activity_log
");

include '../includes/header.php';
include '../includes/sidebar.php';
?>
<div class="container-fluid">
  <h1 class="mt-4 mb-2">📈 KPI Dashboard</h1>
  <p class="text-muted mb-4">Key indicators for full bins, dumped bins and boxes produced.</p>

  <div class="row g-4">

    <!-- FULL BINS STATUS -->
    <div class="col-lg-6">
      <div class="card shadow-sm border-0">
        <div class="card-header bg-white">
          <strong>Full Bins Status</strong>
        </div>
        <div class="card-body">
          <div class="row text-center">
            <div class="col-6 col-md-3 mb-3">
              <div class="text-muted small">Available</div>
              <div class="fs-3 fw-bold"><?php echo $full_available; ?></div>
            </div>
            <div class="col-6 col-md-3 mb-3">
              <div class="text-muted small">In production</div>
              <div class="fs-3 fw-bold"><?php echo $full_in_production; ?></div>
            </div>
            <div class="col-6 col-md-3 mb-3">
              <div class="text-muted small">Used</div>
              <div class="fs-3 fw-bold"><?php echo $full_used; ?></div>
            </div>
            <div class="col-6 col-md-3 mb-3">
              <div class="text-muted small">Scrap</div>
              <div class="fs-3 fw-bold text-danger"><?php echo $full_scrap; ?></div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- DUMPED BINS KPI -->
    <div class="col-lg-6">
      <div class="card shadow-sm border-0">
        <div class="card-header bg-white">
          <strong>Dumped Bins</strong>
        </div>
        <div class="card-body">
          <div class="row text-center">
            <div class="col-6 col-md-3 mb-3">
              <div class="text-muted small">Today</div>
              <div class="fs-3 fw-bold"><?php echo $dumped_today; ?></div>
            </div>
            <div class="col-6 col-md-3 mb-3">
              <div class="text-muted small">This week</div>
              <div class="fs-3 fw-bold"><?php echo $dumped_week; ?></div>
            </div>
            <div class="col-6 col-md-3 mb-3">
              <div class="text-muted small">This month</div>
              <div class="fs-3 fw-bold"><?php echo $dumped_month; ?></div>
            </div>
            <div class="col-6 col-md-3 mb-3">
              <div class="text-muted small">Total</div>
              <div class="fs-3 fw-bold"><?php echo $dumped_total; ?></div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- BOXES PRODUCED KPI -->
    <div class="col-lg-6">
      <div class="card shadow-sm border-0">
        <div class="card-header bg-white">
          <strong>Boxes Produced</strong>
        </div>
        <div class="card-body">
          <div class="row text-center">
            <div class="col-6 col-md-3 mb-3">
              <div class="text-muted small">Today</div>
              <div class="fs-3 fw-bold"><?php echo $boxes_today; ?></div>
            </div>
            <div class="col-6 col-md-3 mb-3">
              <div class="text-muted small">This week</div>
              <div class="fs-3 fw-bold"><?php echo $boxes_week; ?></div>
            </div>
            <div class="col-6 col-md-3 mb-3">
              <div class="text-muted small">This month</div>
              <div class="fs-3 fw-bold"><?php echo $boxes_month; ?></div>
            </div>
            <div class="col-6 col-md-3 mb-3">
              <div class="text-muted small">Total</div>
              <div class="fs-3 fw-bold"><?php echo $boxes_total; ?></div>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div> <!-- /row -->
</div>

<?php include '../includes/footer.php'; ?>
