<?php
require_once __DIR__ . '/../includes/db.php';

$fieldId    = isset($_GET['field_id']) ? (int)$_GET['field_id'] : 0;
$templateId = isset($_GET['template_id']) ? (int)$_GET['template_id'] : 0;

if ($fieldId <= 0 || $templateId <= 0) {
  header('Content-Type: application/json');
  echo json_encode([]);
  exit;
}

/*
  Carichiamo i preset SOLO se:
  - il field esiste
  - appartiene al template corrente
*/
$stmt = $pdo->prepare("
  SELECT p.id, p.name
  FROM bol_value_presets p
  JOIN bol_fields f ON f.id = p.field_id
  WHERE p.field_id = ?
    AND f.template_id = ?
  ORDER BY p.name
");
$stmt->execute([$fieldId, $templateId]);

header('Content-Type: application/json');
echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
