<?php
require_once __DIR__ . '/../config/user_functions.php';

session_start();
require_once __DIR__ . '/../includes/lang.php';
require_once __DIR__ . '/../config/db_remote.php';

$user = $_SESSION['user'] ?? null;
$role = $user['role'] ?? 'viewer';
if ($role !== 'admin') {
    die("You do not have permission to view this page.");
}

// simple filter
$level = $_GET['level'] ?? '';
$allowedLevels = ['INFO','WARN','ERROR'];
$where = '';
if ($level && in_array($level, $allowedLevels, true)) {
    $levelEsc = $mysqli->real_escape_string($level);
    $where = "WHERE level = '$levelEsc'";
}

$res = $mysqli->query("SELECT id, level, message, created_at FROM keyence_logs $where ORDER BY id DESC LIMIT 300");
$logs = [];
if ($res) {
    while ($row = $res->fetch_assoc()) {
        $logs[] = $row;
    }
}
?>
<?php include('../includes/header.php'); ?>
<?php include('../includes/sidebar.php'); ?>

<div class="container-fluid mt-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <h3><?= htmlspecialchars($t['keyence']['logs_title']) ?></h3>
    <form method="post" action="keyence_restart.php" onsubmit="return confirm('Restart Keyence service?');">
      <button class="btn btn-sm btn-warning">
        <?= htmlspecialchars($t['keyence']['restart']) ?>
      </button>
    </form>
  </div>

  <form method="get" class="row g-2 mb-3">
    <div class="col-auto">
      <select name="level" class="form-select form-select-sm">
        <option value="">All levels</option>
        <?php foreach ($allowedLevels as $lvl): ?>
          <option value="<?= $lvl ?>" <?= $lvl===$level?'selected':'' ?>><?= $lvl ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-auto">
      <button class="btn btn-sm btn-primary">Filter</button>
    </div>
  </form>

  <div class="card">
    <div class="card-body" style="max-height: 600px; overflow:auto;">
      <table class="table table-sm table-striped table-hover align-middle">
        <thead>
          <tr>
            <th>ID</th>
            <th>Level</th>
            <th>Message</th>
            <th>Created at</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($logs as $log): ?>
          <tr>
            <td><?= (int)$log['id'] ?></td>
            <td>
              <?php
                $badge = 'secondary';
                if ($log['level']==='INFO') $badge='primary';
                elseif ($log['level']==='WARN') $badge='warning';
                elseif ($log['level']==='ERROR') $badge='danger';
              ?>
              <span class="badge bg-<?= $badge ?>"><?= htmlspecialchars($log['level']) ?></span>
            </td>
            <td><code><?= htmlspecialchars($log['message']) ?></code></td>
            <td><?= htmlspecialchars($log['created_at']) ?></td>
          </tr>
          <?php endforeach; ?>
          <?php if (empty($logs)): ?>
          <tr><td colspan="4" class="text-muted">No logs.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

</div>
