<?php
require_once __DIR__ . '/../config/user_functions.php';

session_start();
$user = $_SESSION['user'] ?? null;
$role = $user['role'] ?? 'viewer';
if ($role !== 'admin') { die("Not allowed."); }
?>
<?php include('../includes/header.php'); ?>
<?php include('../includes/sidebar.php'); ?>

<div class="container-fluid mt-3">
  <h3 class="mb-4 fw-bold">Keyence Control Panel</h3>

  <div class="row g-4">
    <div class="col-md-4">
      <a href="/smproduce/pages/keyence_monitor.php" class="text-decoration-none text-dark">
        <div class="card card-apple p-4 text-center">
          <div class="icon-lg mb-2">📡</div>
          <h5 class="fw-bold">Monitor</h5>
          <p class="text-muted small">Latest events and status</p>
        </div>
      </a>
    </div>

    <div class="col-md-4">
      <a href="/smproduce/pages/listener_control.php" class="text-decoration-none text-dark">
        <div class="card card-apple p-4 text-center">
          <div class="icon-lg mb-2">⚙️</div>
          <h5 class="fw-bold">Listener Control</h5>
          <p class="text-muted small">Start / stop Windows service</p>
        </div>
      </a>
    </div>

    <div class="col-md-4">
      <a href="/smproduce/pages/listener_logs.php" class="text-decoration-none text-dark">
        <div class="card card-apple p-4 text-center">
          <div class="icon-lg mb-2">🧾</div>
          <h5 class="fw-bold">Listener Logs</h5>
          <p class="text-muted small">BARCODE + raw TCP log</p>
        </div>
      </a>
    </div>

    <div class="col-md-4">
      <a href="/smproduce/pages/keyence_logs.php" class="text-decoration-none text-dark">
        <div class="card card-apple p-4 text-center">
          <div class="icon-lg mb-2">📄</div>
          <h5 class="fw-bold">Keyence Logs</h5>
          <p class="text-muted small">All events with filters</p>
        </div>
      </a>
    </div>
  </div>
</div>
