<?php
require_once __DIR__ . '/../config/user_functions.php';

session_start();
if (!isset($_SESSION['user'])) { header('Location: /smproduce/auth/login.php'); exit; }
require_once __DIR__ . '/../config/users_local.php';
if (!user_has_permission('orders')) {
    http_response_code(403);
    echo "<h3>Access denied</h3>";
    exit;
}
require_once __DIR__ . '/../config/db_remote.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    echo "Invalid order id.";
    exit;
}

$res = $mysqli->query("SELECT * FROM orders WHERE id = {$id} LIMIT 1");
if (!$res || !$res->num_rows) {
    echo "Order not found.";
    exit;
}
$order = $res->fetch_assoc();

$po        = $order['po_number'] ?? '';
$customer  = $order['customer'] ?? '';
$product   = $order['product'] ?? '';
$qty       = $order['quantity'] ?? '';
$ship_date = $order['ship_date'] ?? '';
$status    = $order['status'] ?? '';
$notes     = $order['notes'] ?? '';
$created   = $order['created_at'] ?? '';

$html = '<html><head><meta charset="utf-8"><style>
body { font-family: DejaVu Sans, Arial, sans-serif; font-size: 12px; }
h1 { font-size: 18px; margin-bottom: 4px; }
h2 { font-size: 14px; margin-top: 0; color: #555; }
table { border-collapse: collapse; width: 100%; margin-top: 10px; }
td, th { border: 1px solid #ccc; padding: 6px; }
.section-title { font-weight:bold; margin-top:12px; }
.small { font-size:10px; color:#666; }
</style></head><body>';

$html .= '<h1>SM PRODUCE</h1>';
$html .= '<h2>Order Summary</h2>';
$html .= '<p class="small">Generated at: '.date('Y-m-d H:i:s').'</p>';

$html .= '<table>';
$html .= '<tr><th style="width:25%;">Order ID</th><td>'.htmlspecialchars($order['id']).'</td></tr>';
$html .= '<tr><th>PO Number</th><td>'.htmlspecialchars($po).'</td></tr>';
$html .= '<tr><th>Customer</th><td>'.htmlspecialchars($customer).'</td></tr>';
$html .= '<tr><th>Product</th><td>'.htmlspecialchars($product).'</td></tr>';
$html .= '<tr><th>Quantity</th><td>'.htmlspecialchars($qty).'</td></tr>';
$html .= '<tr><th>Ship Date</th><td>'.htmlspecialchars($ship_date).'</td></tr>';
$html .= '<tr><th>Status</th><td>'.htmlspecialchars($status).'</td></tr>';
$html .= '<tr><th>Created at</th><td>'.htmlspecialchars($created).'</td></tr>';
$html .= '</table>';

$html .= '<div class="section-title">Notes</div>';
$html .= '<div style="min-height:80px;border:1px solid #ccc;padding:6px;margin-bottom:16px;">'.nl2br(htmlspecialchars($notes)).'</div>';

$html .= '<div class="section-title">Signatures</div>';
$html .= '<table><tr><td style="height:60px;">Prepared by:</td><td>Approved by:</td><td>Received by:</td></tr></table>';

$html .= '</body></html>';

// Try dompdf if available
$vendorAutoload = __DIR__ . '/../vendor/autoload.php';
if (file_exists($vendorAutoload)) {
    require_once $vendorAutoload;
    if (class_exists('\Dompdf\Dompdf')) {
        $dompdf = new \Dompdf\Dompdf();
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();
        $dompdf->stream('order_'.$id.'.pdf', ['Attachment' => false]);
        exit;
    }
}

// Fallback: render HTML in browser
echo $html;
