<?php
require_once __DIR__ . '/../config/user_functions.php';

if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../config/users_local.php';
require_once __DIR__ . '/../config/orders_lib.php';

if (!user_has_permission('orders')) {
    http_response_code(403);
    include '../includes/header.php';
    include '../includes/sidebar.php';
    echo "<div class='container-fluid py-4'><h3 class='text-danger'>Access denied</h3></div>";
    include '../includes/footer.php';
    exit;
}

$orders  = load_orders();
$clients = load_clients();
$products = load_products();

// simple search
$q = trim($_GET['q'] ?? '');
if ($q !== '') {
    $q_low = mb_strtolower($q);
    $orders = array_filter($orders, function($o) use ($q_low) {
        $txt = mb_strtolower(
            ($o['po'] ?? '') . ' ' .
            ($o['client'] ?? '') . ' ' .
            ($o['product'] ?? '') . ' ' .
            ($o['notes'] ?? '')
        );
        return strpos($txt, $q_low) !== false;
    });
}

// sort by id desc
usort($orders, function($a,$b){
    return ($b['id'] ?? 0) <=> ($a['id'] ?? 0);
});

include '../includes/header.php';
include '../includes/sidebar.php';
?>
<div class="container-fluid py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="mb-0">Orders</h3>
    <a href="orders_add.php" class="btn btn-primary">Add New Order</a>
  </div>

  <form class="row g-2 mb-3" method="get">
    <div class="col-md-4">
      <input type="text" name="q" class="form-control" placeholder="Search by PO, client, product or notes"
             value="<?= htmlspecialchars($q) ?>">
    </div>
    <div class="col-md-2">
      <button class="btn btn-outline-secondary">Search</button>
    </div>
  </form>

  <div class="card">
    <div class="card-body p-0">
      <div class="table-responsive">
        <table class="table table-striped table-hover mb-0 align-middle">
          <thead class="table-light">
            <tr>
              <th>ID</th>
              <th>PO</th>
              <th>Client</th>
              <th>Ship Date</th>
              <th>Product</th>
              <th class="text-end">Qty</th>
              <th>Notes</th>
              <th style="width:150px;">Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php if (empty($orders)): ?>
              <tr><td colspan="8" class="text-center text-muted py-4">No orders found.</td></tr>
            <?php else: ?>
              <?php foreach ($orders as $o): ?>
                <tr>
                  <td><?= (int)($o['id'] ?? 0) ?></td>
                  <td><?= htmlspecialchars($o['po'] ?? '') ?></td>
                  <td><?= htmlspecialchars($o['client'] ?? '') ?></td>
                  <td><?= htmlspecialchars($o['ship_date'] ?? '') ?></td>
                  <td><?= htmlspecialchars($o['product'] ?? '') ?></td>
                  <td class="text-end"><?= (int)($o['qty'] ?? 0) ?></td>
                  <td><?= htmlspecialchars($o['notes'] ?? '') ?></td>
                  <td>
                    <div class="btn-group btn-group-sm" role="group">
                      <a href="orders_edit.php?id=<?= (int)$o['id'] ?>" class="btn btn-outline-secondary">Edit</a>
                      <a href="orders_print.php?id=<?= (int)$o['id'] ?>" class="btn btn-outline-primary">Print</a>
                      <a href="orders_delete.php?id=<?= (int)$o['id'] ?>"
                         class="btn btn-outline-danger"
                         onclick="return confirm('Delete this order?');">
                        Del
                      </a>
                    </div>
                  </td>
                </tr>
              <?php endforeach; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include '../includes/footer.php'; ?>
