<?php
require_once __DIR__ . '/../config/user_functions.php';

if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../config/users_local.php';
require_once __DIR__ . '/../config/orders_lib.php';

if (!user_has_permission('orders')) {
    http_response_code(403);
    echo "Access denied";
    exit;
}

$orders = load_orders();
$id = (int)($_GET['id'] ?? 0);
$changed = false;
foreach ($orders as $idx => $o) {
    if ((int)($o['id'] ?? 0) === $id) {
        unset($orders[$idx]);
        $changed = true;
        break;
    }
}
if ($changed) {
    save_orders($orders);
}

header('Location: orders.php');
exit;
