<?php
require_once __DIR__.'/db.php';
require_once __DIR__.'/../vendor/autoload.php';

$pdf=new TCPDF('P','mm','A4');
$pdf->SetMargins(0,0,0);
$pdf->AddPage();
$pdf->Image(__DIR__.'/../templates/BILL_OF_LADING_BG.png',0,0,210,297);

$values=[
'date'=>date('Y-m-d'),
'reference'=>'REF-001',
'customer_po'=>'PO-123',
'shipper'=>"SM Produce\nCanada",
'consignee'=>"Client\nToronto",
'pickup_location'=>'Warehouse',
'destination'=>'Toronto',
'awb'=>'BOL-1',
'carrier'=>'Internal',
'notes'=>'Preview PDF'
];

$fields=$pdo->query("SELECT * FROM bol_fields WHERE template_id=1")->fetchAll();

foreach($fields as $f){
if(!isset($values[$f['code']])) continue;

$pdf->SetFont('helvetica','',$f['font_size']);
$pdf->SetXY($f['x_mm'],$f['y_mm']);

if($f['field_type']=='checkbox'){
$pdf->Cell($f['width_mm'],$f['height_mm'],$values[$f['code']]?'X':'');
}
elseif($f['is_multiline']){
$pdf->MultiCell($f['width_mm'],$f['height_mm'],$values[$f['code']],0,$f['align']);
}
else{
$pdf->Cell($f['width_mm'],$f['height_mm'],$values[$f['code']],0,0,$f['align']);
}
}

$pdf->Output('I');
