<?php
require_once __DIR__ . '/../includes/db.php';

$data = json_decode(file_get_contents('php://input'), true);

$stmt = $pdo->prepare("
INSERT INTO bol_document_field_props
(bol_id, field_id, font_family, font_size, align, is_multiline)
VALUES (:b,:f,:ff,:fs,:a,:m)
ON DUPLICATE KEY UPDATE
font_family=VALUES(font_family),
font_size=VALUES(font_size),
align=VALUES(align),
is_multiline=VALUES(is_multiline)
");

$stmt->execute([
  ':b'  => $data['bol_id'],
  ':f'  => $data['field_id'],
  ':ff' => $data['font_family'],
  ':fs' => $data['font_size'],
  ':a'  => $data['align'],
  ':m'  => $data['is_multiline']
]);

echo json_encode(['ok'=>true]);
