<?php
require_once __DIR__ . '/../config/user_functions.php';

session_start();
$role = $_SESSION['user']['role'] ?? 'viewer';
if ($role !== 'admin') {
    http_response_code(403);
    die('Access denied');
}

function run_cmd($cmd) {
    $out = shell_exec($cmd . ' 2>&1');
    if (!$out) $out = '(no output)';
    return htmlspecialchars($out);
}

$console = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['start'])) {
        $console = run_cmd('nssm start keyence_listener');
    } elseif (isset($_POST['stop'])) {
        $console = run_cmd('nssm stop keyence_listener');
    } elseif (isset($_POST['restart'])) {
        $console = run_cmd('nssm restart keyence_listener');
    }
}

$last_msg = '(no data)';
$last_path = __DIR__ . '/../keyence_listener/last_keyence_message.txt';
if (is_file($last_path)) {
    $last_msg = htmlspecialchars(file_get_contents($last_path));
}

// quick ping & port test
$ip = '192.168.1.180';
$port = 8500;

$ping_ok = false;
$ping_out = shell_exec('ping -n 1 ' . escapeshellarg($ip) . ' 2>&1');
if ($ping_out && stripos($ping_out, 'TTL=') !== false) {
    $ping_ok = true;
}

$port_ok = false;
$errno = 0; $errstr = '';
$fp = @fsockopen($ip, $port, $errno, $errstr, 1);
if ($fp) {
    $port_ok = true;
    fclose($fp);
}

include('../includes/header.php');
include('../includes/sidebar.php');
?>
<div class="container-fluid mt-4" style="max-width:1100px;">

  <h3 class="mb-4">🔧 Keyence Listener Control (SR-1000W)</h3>

  <div class="card mb-3">
    <div class="card-header fw-semibold">Status</div>
    <div class="card-body">
      <div class="row text-center">
        <div class="col-md-4 mb-3">
          <h6>Ping Device (<?= htmlspecialchars($ip) ?>)</h6>
          <?php if ($ping_ok): ?>
            <span class="badge bg-success p-2">ONLINE</span>
          <?php else: ?>
            <span class="badge bg-danger p-2">OFFLINE</span>
          <?php endif; ?>
        </div>
        <div class="col-md-4 mb-3">
          <h6>Port <?= (int)$port ?></h6>
          <?php if ($port_ok): ?>
            <span class="badge bg-success p-2">OPEN</span>
          <?php else: ?>
            <span class="badge bg-danger p-2">CLOSED</span>
          <?php endif; ?>
        </div>
        <div class="col-md-4 mb-3">
          <h6>Windows Service</h6>
          <span class="badge bg-secondary p-2">keyence_listener (managed by NSSM)</span>
        </div>
      </div>
    </div>
  </div>

  <div class="card mb-3">
    <div class="card-header fw-semibold">Commands</div>
    <div class="card-body">
      <form method="post" class="mb-3">
        <button name="start" class="btn btn-success me-2">▶ Start</button>
        <button name="stop" class="btn btn-danger me-2">⏹ Stop</button>
        <button name="restart" class="btn btn-warning">⟳ Restart</button>
      </form>
      <label class="form-label fw-semibold">Console output</label>
      <pre class="bg-dark text-light p-3 rounded" style="min-height:120px;"><?= $console ?: 'Ready.' ?></pre>
    </div>
  </div>

  <div class="card mb-3">
    <div class="card-header fw-semibold">Last Keyence message</div>
    <div class="card-body">
      <pre class="bg-light p-3 rounded" style="min-height:80px;"><?= $last_msg ?></pre>
    </div>
  </div>

</div>
<?php include('../includes/footer.php'); ?>
