<?php
require_once __DIR__ . '/../config/user_functions.php';

if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../config/users_local.php';

if (!user_has_permission('settings')) {
    http_response_code(403);
    include '../includes/header.php';
    include '../includes/sidebar.php';
    echo "<div class='container-fluid py-4'><h3 class='text-danger'>Access denied</h3></div>";
    include '../includes/footer.php';
    exit;
}

$printerFile   = __DIR__ . '/../config/printer_settings.json';
$printerConfig = file_exists($printerFile)
    ? (json_decode(file_get_contents($printerFile), true) ?: [])
    : [];

// default config
$fields = $printerConfig['label_fields'] ?? [
    'grower'     => true,
    'variety'    => true,
    'date'       => true,
    'bins_total' => true,
    'lot'        => true,
    'barcode'    => true
];

if (!isset($printerConfig['module_enabled'])) {
    $printerConfig['module_enabled'] = true;
}
if (!isset($printerConfig['full_bins_preview'])) {
    $printerConfig['full_bins_preview'] = true;
}
if (empty($printerConfig['full_bins_mode'])) {
    $printerConfig['full_bins_mode'] = 'manual';
}
if (empty($printerConfig['full_bins_layout'])) {
    $printerConfig['full_bins_layout'] = 'layout_a';
}
if (empty($printerConfig['full_bins_dpi'])) {
    $printerConfig['full_bins_dpi'] = 203;
}

$msg = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $fields = [
        'grower'     => isset($_POST['f_grower']),
        'variety'    => isset($_POST['f_variety']),
        'date'       => isset($_POST['f_date']),
        'bins_total' => isset($_POST['f_bins_total']),
        'lot'        => isset($_POST['f_lot']),
        'barcode'    => isset($_POST['f_barcode']),
    ];
    $printerConfig['label_fields'] = $fields;

    // abilita/disabilita modulo
    $printerConfig['module_enabled']    = !empty($_POST['module_enabled']);

    // preview ON/OFF
    $printerConfig['full_bins_preview'] = !empty($_POST['full_bins_preview']);

    // layout
    $printerConfig['full_bins_layout']  = $_POST['full_bins_layout'] ?? 'layout_a';

    // modalità stampa
    $mode = $_POST['full_bins_mode'] ?? 'manual';
    $printerConfig['full_bins_mode'] = in_array($mode, ['manual', 'auto_confirm'], true) ? $mode : 'manual';

    // DPI
    $dpi = (int)($_POST['full_bins_dpi'] ?? 203);
    if (!in_array($dpi, [203, 300], true)) {
        $dpi = 203;
    }
    $printerConfig['full_bins_dpi'] = $dpi;

    file_put_contents($printerFile, json_encode($printerConfig, JSON_PRETTY_PRINT));
    $msg = "Label options saved.";
}

$currentLayout = $printerConfig['full_bins_layout'] ?? 'layout_a';
$currentMode   = $printerConfig['full_bins_mode']   ?? 'manual';
$currentDpi    = (int)($printerConfig['full_bins_dpi'] ?? 203);

include '../includes/header.php';
include '../includes/sidebar.php';
?>
<div class="container-fluid py-4">
  <h3 class="mb-3">Full Bin Label Options</h3>
  <p class="text-muted">Configura il modulo di stampa delle etichette per i singoli full bins.</p>

  <?php if ($msg): ?>
    <div class="alert alert-success"><?= htmlspecialchars($msg) ?></div>
  <?php endif; ?>

  <form method="post" class="card p-4" style="max-width:720px;">

    <h5>Modulo</h5>
    <div class="form-check mb-3">
      <input class="form-check-input" type="checkbox" id="module_enabled" name="module_enabled"
        <?= !empty($printerConfig['module_enabled']) ? 'checked' : '' ?>>
      <label class="form-check-label" for="module_enabled">
        Abilita modulo FULL BIN LABEL PRINTING
      </label>
      <div class="form-text">Se disabilitato, la pagina di stampa non permetterà la stampa né la preview.</div>
    </div>

    <h5>Campi sull'etichetta</h5>
    <div class="form-check">
      <input class="form-check-input" type="checkbox" id="f_grower" name="f_grower" <?= !empty($fields['grower']) ? 'checked' : '' ?>>
      <label class="form-check-label" for="f_grower">Grower</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="checkbox" id="f_variety" name="f_variety" <?= !empty($fields['variety']) ? 'checked' : '' ?>>
      <label class="form-check-label" for="f_variety">Variety</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="checkbox" id="f_date" name="f_date" <?= !empty($fields['date']) ? 'checked' : '' ?>>
      <label class="form-check-label" for="f_date">Date</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="checkbox" id="f_bins_total" name="f_bins_total" <?= !empty($fields['bins_total']) ? 'checked' : '' ?>>
      <label class="form-check-label" for="f_bins_total">Bins total in lot</label>
    </div>
    <div class="form-check mb-3">
      <input class="form-check-input" type="checkbox" id="f_lot" name="f_lot" <?= !empty($fields['lot']) ? 'checked' : '' ?>>
      <label class="form-check-label" for="f_lot">Lot</label>
    </div>
    <div class="form-check mb-3">
      <input class="form-check-input" type="checkbox" id="f_barcode" name="f_barcode" <?= !empty($fields['barcode']) ? 'checked' : '' ?>>
      <label class="form-check-label" for="f_barcode">Barcode (Code128 + FBIN-xxxxxx)</label>
    </div>

    <hr class="mt-4 mb-3">

    <h5>Layout etichetta</h5>
    <div class="mb-3">
      <label for="full_bins_layout" class="form-label">Layout style</label>
      <select name="full_bins_layout" id="full_bins_layout" class="form-select">
        <option value="layout_a" <?= $currentLayout === 'layout_a' ? 'selected' : '' ?>>Layout A – semplice</option>
        <option value="layout_b" <?= $currentLayout === 'layout_b' ? 'selected' : '' ?>>Layout B – medio</option>
        <option value="layout_c" <?= $currentLayout === 'layout_c' ? 'selected' : '' ?>>Layout C – completo</option>
      </select>
      <div class="form-text">Cambia la disposizione dei testi sull'etichetta.</div>
    </div>

    <h5>Modalità stampa</h5>
    <div class="mb-3">
      <div class="form-check">
        <input class="form-check-input" type="radio" id="mode_manual" name="full_bins_mode" value="manual"
          <?= $currentMode === 'manual' ? 'checked' : '' ?>>
        <label class="form-check-label" for="mode_manual">
          Manuale – stampa solo quando premi il pulsante "Stampa"
        </label>
      </div>
      <div class="form-check">
        <input class="form-check-input" type="radio" id="mode_auto" name="full_bins_mode" value="auto_confirm"
          <?= $currentMode === 'auto_confirm' ? 'checked' : '' ?>>
        <label class="form-check-label" for="mode_auto">
          Automatica con conferma – la pagina si può aprire automaticamente e tu confermi prima di stampare
        </label>
      </div>
    </div>

    <h5>Preview</h5>
    <div class="form-check mb-3">
      <input class="form-check-input" type="checkbox" id="full_bins_preview" name="full_bins_preview"
        <?= !empty($printerConfig['full_bins_preview']) ? 'checked' : '' ?>>
      <label class="form-check-label" for="full_bins_preview">
        Abilita preview grafica per i singoli bins
      </label>
      <div class="form-text">La preview è solo per le etichette dei singoli bins, non per gruppi.</div>
    </div>

    <h5>DPI etichetta</h5>
    <div class="mb-3">
      <div class="form-check">
        <input class="form-check-input" type="radio" id="dpi_203" name="full_bins_dpi" value="203"
          <?= $currentDpi === 203 ? 'checked' : '' ?>>
        <label class="form-check-label" for="dpi_203">
          203 DPI (standard Zebra)
        </label>
      </div>
      <div class="form-check">
        <input class="form-check-input" type="radio" id="dpi_300" name="full_bins_dpi" value="300"
          <?= $currentDpi === 300 ? 'checked' : '' ?>>
        <label class="form-check-label" for="dpi_300">
          300 DPI (alta qualità)
        </label>
      </div>
      <div class="form-text">La preview e il layout della label verranno generati con il DPI selezionato.</div>
    </div>

    <button class="btn btn-primary mt-2">Save Label Options</button>
  </form>
</div>
<?php include '../includes/footer.php'; ?>
