<?php
require_once __DIR__ . '/../config/user_functions.php';

if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once __DIR__ . '/../config/users_local.php';

if (!user_has_permission('settings')) {
    http_response_code(403);
    include '../includes/header.php';
    include '../includes/sidebar.php';
    echo "<div class='container-fluid py-4'><h3 class='text-danger'>Access denied</h3></div>";
    include '../includes/footer.php';
    exit;
}

$printerFile   = __DIR__ . '/../config/printer_settings.json';
$printerConfig = file_exists($printerFile) ? (json_decode(file_get_contents($printerFile), true) ?: []) : [];
$fields = $printerConfig['report_fields'] ?? [
    'grower'     => true,
    'variety'    => true,
    'date'       => true,
    'bins_total' => true,
    'lot'        => true,
    'comments'   => true
];

$msg = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fields = [
        'grower'     => isset($_POST['f_grower']),
        'variety'    => isset($_POST['f_variety']),
        'date'       => isset($_POST['f_date']),
        'bins_total' => isset($_POST['f_bins_total']),
        'lot'        => isset($_POST['f_lot']),
        'comments'   => isset($_POST['f_comments']),
    ];
    $printerConfig['report_fields'] = $fields;
    file_put_contents($printerFile, json_encode($printerConfig, JSON_PRETTY_PRINT));
    $msg = "Report options saved.";
}

include '../includes/header.php';
include '../includes/sidebar.php';
?>
<div class="container-fluid py-4">
  <h3 class="mb-3">Reports Options</h3>
  <p class="text-muted">Choose which columns to include by default in reports.</p>

  <?php if ($msg): ?>
    <div class="alert alert-success"><?= htmlspecialchars($msg) ?></div>
  <?php endif; ?>

  <form method="post" class="card p-4" style="max-width:520px;">
    <div class="form-check">
      <input class="form-check-input" type="checkbox" id="f_grower" name="f_grower" <?= !empty($fields['grower']) ? 'checked' : '' ?>>
      <label class="form-check-label" for="f_grower">Grower</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="checkbox" id="f_variety" name="f_variety" <?= !empty($fields['variety']) ? 'checked' : '' ?>>
      <label class="form-check-label" for="f_variety">Variety</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="checkbox" id="f_date" name="f_date" <?= !empty($fields['date']) ? 'checked' : '' ?>>
      <label class="form-check-label" for="f_date">Date</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="checkbox" id="f_bins_total" name="f_bins_total" <?= !empty($fields['bins_total']) ? 'checked' : '' ?>>
      <label class="form-check-label" for="f_bins_total">Bins total in lot</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="checkbox" id="f_lot" name="f_lot" <?= !empty($fields['lot']) ? 'checked' : '' ?>>
      <label class="form-check-label" for="f_lot">Lot</label>
    </div>
    <div class="form-check mb-3">
      <input class="form-check-input" type="checkbox" id="f_comments" name="f_comments" <?= !empty($fields['comments']) ? 'checked' : '' ?>>
      <label class="form-check-label" for="f_comments">Comments</label>
    </div>

    <button class="btn btn-primary mt-2">Save Report Options</button>
  </form>
</div>
<?php include '../includes/footer.php'; ?>
