<?php
require_once __DIR__ . '/printer_manager.php';

// Carichiamo IP Zebra da config
$settingsFile = __DIR__ . '/../config/printer_settings.json';
$cfg = file_exists($settingsFile) ? json_decode(file_get_contents($settingsFile), true) : [];
$defaultIp = $cfg['zebra_fullbin_ip'] ?? '';

$ip = $_GET['ip'] ?? $defaultIp;
$diag = null;

if ($ip) {
    $diag = zebra_diagnostics($ip);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Zebra Diagnostics</title>
<style>
body {
    font-family: system-ui, sans-serif;
    background: #f5f5f5;
    margin: 0;
    padding: 16px;
}
.card {
    max-width: 900px;
    margin: 0 auto;
    background: #fff;
    border-radius: 6px;
    padding: 16px;
    border: 1px solid #ddd;
}
pre {
    background: #111;
    color: #0f0;
    padding: 10px;
    border-radius: 4px;
    max-height: 250px;
    overflow: auto;
    font-size: 12px;
}
label, input {
    font-size: 14px;
}
input[type=text] {
    padding: 4px 8px;
    width: 220px;
}
button {
    padding: 6px 12px;
    font-size: 13px;
    border-radius: 4px;
    border: 1px solid #007bff;
    color: #fff;
    background: #007bff;
    cursor: pointer;
}
h3 { margin-top: 0; }
.badge {
    display: inline-block;
    padding: 3px 7px;
    border-radius: 999px;
    font-size: 11px;
    color: #fff;
}
.badge-ok { background: #28a745; }
.badge-bad { background: #dc3545; }
</style>
</head>
<body>

<div class="card">
    <h3>Zebra Diagnostics</h3>

    <form method="get" style="margin-bottom:12px;">
        <label>
            Zebra IP:
            <input type="text" name="ip" value="<?= htmlspecialchars($ip) ?>" placeholder="192.168.1.50">
        </label>
        <button type="submit">Run diagnostics</button>
    </form>

    <?php if ($diag): ?>
        <p>
            Socket: 
            <?php if ($diag['socket_ok']): ?>
                <span class="badge badge-ok">OK</span>
            <?php else: ?>
                <span class="badge badge-bad">FAIL</span>
                (<?= htmlspecialchars($diag['error']) ?>)
            <?php endif; ?>
        </p>

        <h4>~HS (Health Status)</h4>
        <pre><?= htmlspecialchars($diag['hs'] ?? '(no data)') ?></pre>

        <h4>^XA^HH^XZ (Config)</h4>
        <pre><?= htmlspecialchars($diag['config'] ?? '(no data)') ?></pre>

        <h4>~HQES (Error / Sensor)</h4>
        <pre><?= htmlspecialchars($diag['hqes'] ?? '(no data)') ?></pre>

    <?php elseif ($ip): ?>
        <p>No data.</p>
    <?php else: ?>
        <p>Inserisci l'IP della Zebra e premi "Run diagnostics".</p>
    <?php endif; ?>
</div>

</body>
</html>
