<?php

// Scale helper (valori pensati per 203 dpi, scalati per 300)
function z($val203, $dpi) {
    return ($dpi == 300) ? intval($val203 * 1.47) : $val203;
}

/**
 * renderBinLabel
 *
 * Layout:
 *  - layout_a: testo in alto, barcode centrato in basso
 *  - layout_b: barcode grosso a sinistra, testo su colonna destra
 *  - layout_c: testo compatto in alto, barcode enorme full width
 */
function renderBinLabel($layout, $data, $fields, $dpi = 203) {

    $pw = z(609, $dpi);   // ~4"
    $ph = z(406, $dpi);   // ~2"

    $zpl  = "^XA\n";
    $zpl .= "^PW{$pw}\n";
    $zpl .= "^LL{$ph}\n";
    $zpl .= "^CI28\n"; // UTF-8 mode

    // Normalizziamo layout
    if (!in_array($layout, ['layout_a', 'layout_b', 'layout_c'])) {
        $layout = 'layout_a';
    }

    // ---------------------------
    // LAYOUT A: classico
    // ---------------------------
    if ($layout === 'layout_a') {

        $x = 20;
        $y = 20;

        if (!empty($fields["grower"]) && !empty($data['grower'])) {
            $zpl .= "^FO{$x}," . z($y, $dpi) . "^A0N," . z(40, $dpi) . "," . z(40, $dpi) .
                    "^FD" . $data['grower'] . "^FS\n";
            $y += 50;
        }

        if (!empty($fields["variety"]) && !empty($data['variety'])) {
            $zpl .= "^FO{$x}," . z($y, $dpi) . "^A0N," . z(35, $dpi) . "," . z(35, $dpi) .
                    "^FD" . $data['variety'] . "^FS\n";
            $y += 45;
        }

        if (!empty($fields["date"]) && !empty($data['date'])) {
            $zpl .= "^FO{$x}," . z($y, $dpi) . "^A0N," . z(30, $dpi) . "," . z(30, $dpi) .
                    "^FD" . $data['date'] . "^FS\n";
            $y += 40;
        }

        if (!empty($fields["bins_total"])) {
            $txt = "Total bins: " . ($data['bins_total'] ?? '');
            $zpl .= "^FO{$x}," . z($y, $dpi) . "^A0N," . z(28, $dpi) . "," . z(28, $dpi) .
                    "^FD" . $txt . "^FS\n";
            $y += 40;
        }

        if (!empty($fields["lot"]) && !empty($data["lot"])) {
            $zpl .= "^FO{$x}," . z($y, $dpi) . "^A0N," . z(28, $dpi) . "," . z(28, $dpi) .
                    "^FDLot: {$data['lot']}^FS\n";
            $y += 40;
        }

        // BARCODE in basso
        if (!empty($fields["barcode"]) && !empty($data["barcode"])) {
            $barY = z(220, $dpi);
            $h    = z(80, $dpi);
            $zpl .= "^FO{$x},{$barY}\n";
            $zpl .= "^BY3,2,{$h}\n";
            $zpl .= "^BCN,{$h},Y,N,N\n";
            $zpl .= "^FD{$data['barcode']}^FS\n";
        }

    // ---------------------------
    // LAYOUT B: barcode a sinistra, testo a destra
    // ---------------------------
    } elseif ($layout === 'layout_b') {

        // Barcode grande a sinistra
        if (!empty($fields["barcode"]) && !empty($data["barcode"])) {
            $barX = z(20, $dpi);
            $barY = z(40, $dpi);
            $h    = z(200, $dpi);

            $zpl .= "^FO{$barX},{$barY}\n";
            $zpl .= "^BY4,2,{$h}\n";
            $zpl .= "^BCN,{$h},Y,N,N\n";
            $zpl .= "^FD{$data['barcode']}^FS\n";
        }

        // Colonna testo a destra
        $xText = z(260, $dpi);
        $yText = 30;

        if (!empty($fields["grower"]) && !empty($data['grower'])) {
            $zpl .= "^FO{$xText}," . z($yText, $dpi) . "^A0N," . z(38, $dpi) . "," . z(38, $dpi) .
                    "^FD" . $data['grower'] . "^FS\n";
            $yText += 50;
        }

        if (!empty($fields["variety"]) && !empty($data['variety'])) {
            $zpl .= "^FO{$xText}," . z($yText, $dpi) . "^A0N," . z(34, $dpi) . "," . z(34, $dpi) .
                    "^FD" . $data['variety'] . "^FS\n";
            $yText += 45;
        }

        if (!empty($fields["date"]) && !empty($data['date'])) {
            $zpl .= "^FO{$xText}," . z($yText, $dpi) . "^A0N," . z(30, $dpi) . "," . z(30, $dpi) .
                    "^FD" . $data['date'] . "^FS\n";
            $yText += 40;
        }

        if (!empty($fields["bins_total"])) {
            $txt = "Bins: " . ($data['bins_total'] ?? '');
            $zpl .= "^FO{$xText}," . z($yText, $dpi) . "^A0N," . z(28, $dpi) . "," . z(28, $dpi) .
                    "^FD" . $txt . "^FS\n";
            $yText += 35;
        }

        if (!empty($fields["lot"]) && !empty($data["lot"])) {
            $zpl .= "^FO{$xText}," . z($yText, $dpi) . "^A0N," . z(28, $dpi) . "," . z(28, $dpi) .
                    "^FDLot: {$data['lot']}^FS\n";
        }

    // ---------------------------
    // LAYOUT C: testo compatto in alto, barcode enorme full width
    // ---------------------------
    } elseif ($layout === 'layout_c') {

        $x = 20;
        $y = 20;

        if (!empty($fields["grower"]) && !empty($data['grower'])) {
            $zpl .= "^FO{$x}," . z($y, $dpi) . "^A0N," . z(36, $dpi) . "," . z(36, $dpi) .
                    "^FD" . $data['grower'] . "^FS\n";
            $y += 45;
        }

        if (!empty($fields["variety"]) && !empty($data['variety'])) {
            $zpl .= "^FO{$x}," . z($y, $dpi) . "^A0N," . z(32, $dpi) . "," . z(32, $dpi) .
                    "^FD" . $data['variety'] . "^FS\n";
            $y += 40;
        }

        if (!empty($fields["date"]) && !empty($data['date'])) {
            $zpl .= "^FO{$x}," . z($y, $dpi) . "^A0N," . z(28, $dpi) . "," . z(28, $dpi) .
                    "^FD" . $data['date'] . "^FS\n";
            $y += 35;
        }

        if (!empty($fields["lot"]) && !empty($data["lot"])) {
            $zpl .= "^FO{$x}," . z($y, $dpi) . "^A0N," . z(26, $dpi) . "," . z(26, $dpi) .
                    "^FDLot: {$data['lot']}^FS\n";
            $y += 35;
        }

        if (!empty($fields["bins_total"])) {
            $txt = "Bins: " . ($data['bins_total'] ?? '');
            $zpl .= "^FO{$x}," . z($y, $dpi) . "^A0N," . z(26, $dpi) . "," . z(26, $dpi) .
                    "^FD" . $txt . "^FS\n";
        }

        // Barcode ENORME full width al centro/basso
        if (!empty($fields["barcode"]) && !empty($data["barcode"])) {
            $barY  = z(180, $dpi);
            $h     = z(180, $dpi);
            $barX  = z(40, $dpi);

            $zpl .= "^FO{$barX},{$barY}\n";
            $zpl .= "^BY4,2,{$h}\n";
            $zpl .= "^BCN,{$h},Y,N,N\n";
            $zpl .= "^FD{$data['barcode']}^FS\n";
        }
    }

    $zpl .= "^XZ";

    return $zpl;
}
