<?php
require_once __DIR__ . '/../config/db_remote.php';
require_once __DIR__ . '/print_zpl.php';

$gid = intval($_GET["group_id"]);
$auto = intval($_GET["auto"] ?? 0);

$res = $mysqli->query("SELECT * FROM bins_ingresso WHERE group_id=$gid ORDER BY id ASC");
$rows = $res->fetch_all(MYSQLI_ASSOC);

if (!$rows) die("No bins found.");

$fullZPL = "";

foreach ($rows as $r) {
    $barcode = "FBIN-" . str_pad($r['id'], 6, "0", STR_PAD_LEFT);

    $fullZPL .= "^XA
^PW609
^LL406
^FO20,20^A0N,40,40^FD SM PRODUCE LTD ^FS
^FO20,70^A0N,35,35^FD Grower: {$r['grower']} ^FS
^FO20,115^A0N,30,30^FD Variety: {$r['variety']} ^FS
^FO20,155^A0N,28,28^FD Date: {$r['date']} ^FS
^FO20,205
^BY3,2,80
^BCN,80,Y,N,N
^FD{$barcode}^FS
^XZ\n";
}

if ($auto == 1) {
    printZPL($fullZPL, 1);
    die("<script>window.close();</script>");
}

echo "<pre>".htmlspecialchars($fullZPL)."</pre>";
