<?php
require_once __DIR__ . '/../config/db_remote.php';
require_once __DIR__ . '/zpl_renderer.php';

$id = intval($_GET["id"] ?? 0);
if ($id <= 0) die("Invalid ID");

// ---- LOAD SETTINGS ----
$settingsFile = __DIR__ . '/../config/printer_settings.json';
$cfg = file_exists($settingsFile) ? json_decode(file_get_contents($settingsFile), true) : [];

$fields  = $cfg['label_fields']   ?? [];
$layout  = $cfg['full_bins_layout'] ?? 'layout_a';
$dpi     = intval($cfg['full_bins_dpi'] ?? 203);

// ---- LOAD BIN DATA ----
$res = $mysqli->query("SELECT * FROM bins_ingresso WHERE id=$id");
$row = $res->fetch_assoc();
if (!$row) die("Bin not found");

$payload = [
    "id"        => $id,
    "grower"    => $row["grower"],
    "variety"   => $row["variety"],
    "date"      => $row["date"],
    "bins_total"=> $row["bins_total"],
    "lot"       => $row["lot"],
    "barcode"   => "FBIN-" . str_pad($id, 6, "0", STR_PAD_LEFT)
];

// ---- GET ZPL ----
$zpl = renderBinLabel($layout, $payload, $fields, $dpi);

// ---- RENDER PNG ----
require_once __DIR__ . '/zpl_to_png.php';
$imgBinary = zpl_to_png($zpl, $dpi);

// Base64 per preview browser
$img64 = base64_encode($imgBinary);

// dimensioni reali etichetta 4 x 2 inches
$px_w = intval(4 * $dpi);
$px_h = intval(2 * $dpi);

?>
<!DOCTYPE html>
<html>
<head>
<title>Label Preview</title>
<style>
body {
    background: #f0f0f0;
    padding: 20px;
    font-family: Arial;
}
#viewer-container {
    position: relative;
    width: fit-content;
    margin: auto;
    background: white;
    padding: 40px;
    border: 1px solid #ccc;
}
.label-img {
    display: block;
    image-rendering: pixelated;
}
.ruler-horizontal {
    height: 20px;
    background: repeating-linear-gradient(
        to right,
        #ccc 0px, #ccc 1px,
        transparent 1px, transparent 10px
    );
}
.ruler-vertical {
    width: 20px;
    background: repeating-linear-gradient(
        to bottom,
        #ccc 0px, #ccc 1px,
        transparent 1px, transparent 10px
    );
}
#zoom-container {
    overflow: auto;
    max-width: 100%;
    max-height: 80vh;
}
#download-btn {
    margin-top: 15px;
}
</style>
</head>

<body>

<h2>Preview Full Bin Label</h2>

<p>DPI: <?= $dpi ?> — Layout: <?= htmlspecialchars($layout) ?></p>

<div id="viewer-container">

    <!-- Ruler Top -->
    <div class="ruler-horizontal" style="width:<?= $px_w ?>px;"></div>

    <div style="display:flex">

        <!-- Ruler Left -->
        <div class="ruler-vertical" style="height:<?= $px_h ?>px;"></div>

        <!-- Image Container -->
        <div id="zoom-container">
            <img id="label" class="label-img"
                src="data:image/png;base64,<?= $img64 ?>"
                width="<?= $px_w ?>"
                height="<?= $px_h ?>">
        </div>

    </div>
</div>

<button id="download-btn"
        onclick="downloadPNG()"
        class="btn btn-primary">Download PNG</button>

<script>
let img = document.getElementById("label");
let scale = 1;

document.getElementById("zoom-container").addEventListener("wheel", e => {
    e.preventDefault();
    if (e.deltaY < 0) scale += 0.1;
    else scale -= 0.1;
    if (scale < 0.2) scale = 0.2;
    img.style.transform = "scale(" + scale + ")";
});

function downloadPNG() {
    let a = document.createElement("a");
    a.href = img.src;
    a.download = "label_preview.png";
    a.click();
}
</script>

</body>
</html>
