<?php

// Convert values depending on DPI (203 -> 300)
function z($val203, $dpi) {
    return ($dpi == 300) ? intval($val203 * 1.47) : $val203;
}

function renderBinLabel($layout, $data, $fields, $dpi = 203) {

    $pw = z(609, $dpi);   // label width
    $ph = z(406, $dpi);   // label height

    $zpl  = "^XA\n";
    $zpl .= "^PW{$pw}\n";
    $zpl .= "^LL{$ph}\n";

    $x = 20;
    $y = 20;

    // -------------------------
    // TEXT FIELDS
    // -------------------------

    if (!empty($fields["grower"])) {
        $zpl .= "^FO{$x},".z($y,$dpi)."^A0N,".z(40,$dpi).",".z(40,$dpi)."^FD{$data['grower']}^FS\n";
        $y += 50;
    }

    if (!empty($fields["variety"])) {
        $zpl .= "^FO{$x},".z($y,$dpi)."^A0N,".z(35,$dpi).",".z(35,$dpi)."^FD{$data['variety']}^FS\n";
        $y += 45;
    }

    if (!empty($fields["date"])) {
        $zpl .= "^FO{$x},".z($y,$dpi)."^A0N,".z(30,$dpi).",".z(30,$dpi)."^FD{$data['date']}^FS\n";
        $y += 40;
    }

    if (!empty($fields["bins_total"])) {
        $zpl .= "^FO{$x},".z($y,$dpi)."^A0N,".z(28,$dpi).",".z(28,$dpi)."^FDTotal bins: {$data['bins_total']}^FS\n";
        $y += 40;
    }

    if (!empty($fields["lot"])) {
        $zpl .= "^FO{$x},".z($y,$dpi)."^A0N,".z(28,$dpi).",".z(28,$dpi)."^FDLot: {$data['lot']}^FS\n";
        $y += 40;
    }

    // -------------------------
    // BARCODE
    // -------------------------

    if (!empty($fields["barcode"])) {

        $barcode_height = ($layout === "layout_c")
            ? z(120, $dpi)
            : z(80, $dpi);

        $zpl .= "^FO{$x},".z($y,$dpi)."\n";
        $zpl .= "^BY3,2,{$barcode_height}\n";
        $zpl .= "^BCN,{$barcode_height},Y,N,N\n";
        $zpl .= "^FD{$data['barcode']}^FS\n";
    }

    $zpl .= "^XZ";

    return $zpl;
}
